\model{
	\statevector{
		\type{short}{P0, P1, P2, P3, P4, P5, P6, P7}
	}

	\initial{
		P0 = [pipe.common.dataLayer.Marking@bbd1b]; P1 = [pipe.common.dataLayer.Marking@ac576f]; P2 = [pipe.common.dataLayer.Marking@a07440]; P3 = [pipe.common.dataLayer.Marking@304648]; P4 = [pipe.common.dataLayer.Marking@1565e9d]; P5 = [pipe.common.dataLayer.Marking@15daa9e]; P6 = [pipe.common.dataLayer.Marking@6c9f0f]; P7 = [pipe.common.dataLayer.Marking@13ec758]; 
	}
	\transition{T0}{
		\condition{P0 > 0 && P7 > 0}
		\action{
			next->P0 = P0 - [pipe.common.dataLayer.Marking@917cb0];
			next->P7 = P7 - [pipe.common.dataLayer.Marking@1913751];
			next->P1 = P1 + [pipe.common.dataLayer.Marking@c6b80e];
			next->P6 = P6 + [pipe.common.dataLayer.Marking@5dc268];
		}
		\weight{1.0}
	}
	\transition{T1}{
		\condition{P3 > 0 && P6 > 0}
		\action{
			next->P3 = P3 - [pipe.common.dataLayer.Marking@1866417];
			next->P6 = P6 - [pipe.common.dataLayer.Marking@1526e3];
			next->P4 = P4 + [pipe.common.dataLayer.Marking@ac2d3c];
			next->P7 = P7 + [pipe.common.dataLayer.Marking@1cdc190];
		}
		\weight{1.0}
	}
	\transition{T2}{
		\condition{P4 > 0}
		\action{
			next->P4 = P4 - [pipe.common.dataLayer.Marking@15ede11];
			next->P5 = P5 + [pipe.common.dataLayer.Marking@1455cf4];
		}
		\weight{1.0}
	}
	\transition{T3}{
		\condition{P1 > 0}
		\action{
			next->P1 = P1 - [pipe.common.dataLayer.Marking@d9b071];
			next->P2 = P2 + [pipe.common.dataLayer.Marking@1ceebfa];
		}
		\weight{1.0}
	}
	\transition{T4}{
		\condition{P2 > 0}
		\action{
			next->P2 = P2 - [pipe.common.dataLayer.Marking@1e6743e];
			next->P0 = P0 + [pipe.common.dataLayer.Marking@d9ceea];
		}
		\rate{1.0}
	}
	\transition{T5}{
		\condition{P5 > 0}
		\action{
			next->P5 = P5 - [pipe.common.dataLayer.Marking@19f9c7a];
			next->P3 = P3 + [pipe.common.dataLayer.Marking@1da366c];
		}
		\rate{1.0}
	}
}

\solution{
	\method{sor}

}\performance{
	\statemeasure{Enabled probability for transition T0}{
		\estimator{mean}
		\expression{(P0 > 0 && P7 > 0) ? 1 : 0}
	}
	\countmeasure{Throughput for transition T0}{
		\estimator{mean}
		\precondition{1}
		\postcondition{1}
		\transition{T0}
	}
	\statemeasure{Enabled probability for transition T1}{
		\estimator{mean}
		\expression{(P3 > 0 && P6 > 0) ? 1 : 0}
	}
	\countmeasure{Throughput for transition T1}{
		\estimator{mean}
		\precondition{1}
		\postcondition{1}
		\transition{T1}
	}
	\statemeasure{Enabled probability for transition T2}{
		\estimator{mean}
		\expression{(P4 > 0) ? 1 : 0}
	}
	\countmeasure{Throughput for transition T2}{
		\estimator{mean}
		\precondition{1}
		\postcondition{1}
		\transition{T2}
	}
	\statemeasure{Enabled probability for transition T3}{
		\estimator{mean}
		\expression{(P1 > 0) ? 1 : 0}
	}
	\countmeasure{Throughput for transition T3}{
		\estimator{mean}
		\precondition{1}
		\postcondition{1}
		\transition{T3}
	}
	\statemeasure{Enabled probability for transition T4}{
		\estimator{mean}
		\expression{(P2 > 0) ? 1 : 0}
	}
	\countmeasure{Throughput for transition T4}{
		\estimator{mean}
		\precondition{1}
		\postcondition{1}
		\transition{T4}
	}
	\statemeasure{Enabled probability for transition T5}{
		\estimator{mean}
		\expression{(P5 > 0) ? 1 : 0}
	}
	\countmeasure{Throughput for transition T5}{
		\estimator{mean}
		\precondition{1}
		\postcondition{1}
		\transition{T5}
	}
	\statemeasure{Mean tokens on place P0}{
		\estimator{mean variance distribution}
		\expression{P0}
	}
	\statemeasure{Mean tokens on place P1}{
		\estimator{mean variance distribution}
		\expression{P1}
	}
	\statemeasure{Mean tokens on place P2}{
		\estimator{mean variance distribution}
		\expression{P2}
	}
	\statemeasure{Mean tokens on place P3}{
		\estimator{mean variance distribution}
		\expression{P3}
	}
	\statemeasure{Mean tokens on place P4}{
		\estimator{mean variance distribution}
		\expression{P4}
	}
	\statemeasure{Mean tokens on place P5}{
		\estimator{mean variance distribution}
		\expression{P5}
	}
	\statemeasure{Mean tokens on place P6}{
		\estimator{mean variance distribution}
		\expression{P6}
	}
	\statemeasure{Mean tokens on place P7}{
		\estimator{mean variance distribution}
		\expression{P7}
	}
}
