import java.io.*;
import java.net.*;
import java.util.*;

//custom component by callen shaw for cs2650 hw4
public class CtsTC {
    private Socket s;
    private MsgEncoder me;
    private MsgDecoder md;
    
    //specify the server socket, and limits for blood sugar.  anything lower
    //than or equal to lowBs or >= highBs will return an "abnormal" diagnosis.
    public CtsTC (Socket s) {
        this.s = s;
        try{
            Scanner scan = new Scanner(System.in);
            me = new MsgEncoder();
            md = new MsgDecoder(s.getInputStream());
            KeyValueList l = new KeyValueList();
            //KeyValueList prf = getDefaultProfile("profile.properties");
			System.out.println("TC component.  Connecting to server (ID=23)...");
            l.addPair("MsgID", "23");
            l.addPair("Name", "CtsTC");
            OutputStream sOut = s.getOutputStream(); 
            me.sendMsg(l, sOut);

            l = md.getMsg();
            
            if(l == null)
            	throw new RuntimeException("Init Msg(26) not received: connection closed early.");
            int msgID = Integer.parseInt(l.getValue("MsgID"));
            if(msgID != 26)
            	throw new RuntimeException("Init Msg(26) not received: wrong msgId: " + msgID);
            while(true) {
        		System.out.println("Enter 'e' to eliminate, or 'q' to quit.");
            	String inp = scan.nextLine();
            	if(inp.equals("q"))
            		break;
            	else if(inp.equals("e"))
            	{
            		KeyValueList kvl = new KeyValueList();
            		kvl.addPair("MsgID", "310");
            		kvl.addPair("Description", "kill comps");
            		kvl.addPair("Type", "BloodSugarMonitor");
            		me.sendMsg(kvl, sOut);
            	}
            }
        }
        catch (Exception e) {
			System.out.println("The TC shut down due to errors.");
            System.out.println("An exception occurred: "+e);
			e.printStackTrace();
        }
        
    }
        
    
    public static void main(String[] args) {
        String address;
        int port;
        String name = "CtsTC";
        if(args.length == 1 && args[0].equals("-?"))
        	System.out.println("Usage: java CtsTC [serverIp=127.0.0.1] [serverPort=7999]");
        
        if(args.length > 0)
            address = args[0];
        else
            System.out.println("No address given, assuming " + (address = "127.0.0.1"));

        if(args.length > 1)
            try{
                port = Integer.parseInt(args[1]);
            }catch(Exception e){
				e.printStackTrace();
				System.out.println("No port given, assuming " + (port = 7999));
            }
        else
            System.out.println("No port given, assuming " + (port = 7999));

        try {
            //System.out.println("Address: "+address);
            //System.out.println("Port: "+port);
            
            Socket s = new Socket(address,port);
            CtsTC m = new CtsTC(s);
        }
         
        catch (Exception e) {
			e.printStackTrace();
			System.out.println("An error occurred during CtsTC initialization. Now exiting. " + e);
        }
    }
}