import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;


public class PNDetailFrame extends JFrame implements WindowFocusListener, ActionListener {

	final static String ACTCMD = "action!!!";
	final PNSimFrame Parent ;
	private PNPlace Place = null;
	private PNTransition Trans = null;
	
	public PNDetailFrame(PNSimFrame simframe, PNPlace p) {
		Place = p;
		Parent = simframe;
		init();
	}
	public PNDetailFrame(PNSimFrame simframe, PNTransition t) {
		Trans = t;
		Parent = simframe;
		init();
	}
	
	void init() {
		String[] labels = new String[]{
				"ID", "Type", "Label", "Position.X", "Position.Y", "Input IDs", "Output IDs"
		};
		String[] data = new String[labels.length];
		JButton actionBtn;
		JLabel[][] itemSpecificLabels = new JLabel[2][2];
		itemSpecificLabels[1][0] = itemSpecificLabels[1][1] = new JLabel("");
		if(Place != null) {
			ArrayList<String> in = new ArrayList<String>();
			ArrayList<String> out = new ArrayList<String>();
			for(PNTransition t : Parent.PNData.Transitions){
				for(String inId : t.InputIds)
					if(Place.Id.equals(inId))
						out.add(t.Id);
				for(String outId : t.OutputIds)
					if(Place.Id.equals(outId))
						in.add(t.Id);				
			}
			setTitle("Place Details: " + Place.Id);
			data[0] = Place.Id;
			data[1] = "Place";
			data[2] = "not implemented.";
			data[3] = Place.Position.x+"";
			data[4] = Place.Position.y+"";
			data[5] = Arrays.toString(in.toArray());
			data[6] = Arrays.toString(out.toArray());
			actionBtn = new JButton("Press to put a Token at place " + Place.Id);
			itemSpecificLabels[0][0] = new JLabel("Initial Token");			
			itemSpecificLabels[0][1] = new JLabel((new Boolean(Place.InitiallyMarked)).toString());			
		}else if(Trans != null) {
			setTitle("Transition Details: " + Trans.Id);
			data[0] = Trans.Id;
			data[1] = "Transition";
			data[2] = "not implemented.";
			data[3] = Trans.Position.x+"";
			data[4] = Trans.Position.y+"";
			data[5] = Arrays.toString(Trans.InputIds);
			data[6] = Arrays.toString(Trans.OutputIds);
			actionBtn = new JButton("Press to edit XML message sent by " + Trans.Id);
			itemSpecificLabels[0][0] = new JLabel("XML Msg");
			if(Trans.OnFire == null)
				itemSpecificLabels[0][1] = new JLabel("No Message Sent");
			else
				itemSpecificLabels[0][1] = new JLabel(Trans.OnFire.toString().substring(0, 15));
		}else 
			throw new NullPointerException("null item used to create PNDetailFrame");
		JPanel content = new JPanel(new GridLayout(labels.length+itemSpecificLabels.length+1,1));
		this.add(content);
		content.setBorder(new LineBorder(Color.WHITE, 10));
		content.setBackground(Color.WHITE);
		for(int i=0; i<labels.length; i++) {
			JPanel row = new JPanel(new GridLayout(1,2));
			content.add(row);
			row.setBackground(content.getBackground());
			JLabel lblName = new JLabel(labels[i]+": ", SwingConstants.LEFT);
			JLabel lblVal = new JLabel(data[i], SwingConstants.LEFT);
			row.add(lblName);
			row.add(lblVal);
		}		
		for(int i=0; i<itemSpecificLabels.length; i++) {
			JPanel row = new JPanel(new GridLayout(1,2));
			content.add(row);
			row.setBackground(content.getBackground());
			row.add(itemSpecificLabels[i][0]);			
			row.add(itemSpecificLabels[i][1]);			
		}
		content.add(actionBtn);
		actionBtn.setActionCommand(ACTCMD);
		actionBtn.addActionListener(this);
		this.pack();
		this.addWindowFocusListener(this);
		this.setLocation(Parent.getX()+Parent.getWidth(), Parent.getY());
		this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		setVisible(true);
	}
	@Override
	public void windowGainedFocus(WindowEvent arg0) {
		
	}
	@Override
	public void windowLostFocus(WindowEvent arg0) {
		this.setVisible(false);
	}
	@Override
	public void actionPerformed(ActionEvent arg0) {
		if(!ACTCMD.equals(arg0.getActionCommand())) {
			NetSim.p("UNKNOWN ACTION " + arg0);
			return;
		}
		if(Place!=null) {
			Place.HasToken = true;
			Parent.repaint();
		}
		else {
			this.setVisible(false);
			XmlEditFrame editFrame = new XmlEditFrame(Parent, Trans);
			
		}			
	}
}
