import java.io.*;
import java.net.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;

public class messenger extends JFrame implements ActionListener {
	
	private JTextField jtf = new JTextField();

	
	private JTextArea jta = new JTextArea();

	private DataOutputStream outputToServer;
	private DataInputStream inputFromServer;

	public static void main(String[] args) {
		new messenger();
	}

	public messenger() {
		
		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());
		p.add(new JLabel("Enter XML File List Name"), BorderLayout.WEST);
		p.add(jtf, BorderLayout.CENTER);
		jtf.setHorizontalAlignment(JTextField.RIGHT);

		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(p, BorderLayout.NORTH);
		getContentPane().add(new JScrollPane(jta), BorderLayout.CENTER);

		jtf.addActionListener(this); // Register listener

		setTitle("messenger");
		setSize(500, 300);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setVisible(true); // It is necessary to show the frame here!

		try {
			// Create a socket to connect to the server
			Socket socket = new Socket("127.0.0.1", 7999);

			// Create an output stream to send data to the server
			outputToServer = new DataOutputStream(socket.getOutputStream());
			  
			// Create an input stream to receive data from the server
		  inputFromServer = new DataInputStream(socket.getInputStream());

		    //send the initial MsgID 23 to connect the messenger
			String Msg23_xml = "MsgID$$$23$$$Description$$$Connect to server$$$Passcode$$$****$$$SecurityLevel$$$3$$$Name$$$messenger";
			
			
/**************************************************************/		
//For sending msgs
			
			PrintStream printOut= new PrintStream(outputToServer);
			printOut.println(Msg23_xml);			
/**************************************************************/
			
/************************************************************/
//For receiving msgs

			BufferedReader bufferIn  = new BufferedReader(new InputStreamReader(inputFromServer));
			String input_Msg26 = bufferIn.readLine();
//To here, your messenger can send Msg 23 to the server and receive acknowledge msg
/*************************************************************/
			String[] parts = input_Msg26.split("\\$\\$\\$");
            if(parts[1].matches("26"))
            	jta.append("Recieved acknowledgement message");
            } catch (IOException ex) {
			jta.append(ex.toString() + '\n');
		}
	}
	
	public String xmlParser(String file_name) throws IOException {
		
		BufferedReader input_xml = new BufferedReader(new FileReader(file_name));				
		String delimiter = "$$$";
		String line;
		String output = "";
    	String kvstring="";
		
    	while ((line = input_xml.readLine()) != null){
		      kvstring+=line;
		}		
		line=kvstring.trim();
		
		int msgid_s=line.indexOf(">", line.indexOf("<MsgID>"))+1;
		int msgid_e = line.indexOf("<", msgid_s);
		output += "MsgID" + delimiter
				+ line.substring(msgid_s, msgid_e).trim();
		
		int desp_s = line.indexOf(">", line.indexOf("<Description>", msgid_e)) + 1;
		int desp_e = line.indexOf("<", desp_s);
		output +=  delimiter+"Description" + delimiter+ line.substring(desp_s, desp_e).trim();
		
		int key_s=desp_e, key_e=desp_e, value_s=desp_e, value_e=desp_e;
		while(true){
			key_s=line.indexOf("<Key>", value_e);
			if (key_s!=-1)
				key_s = line.indexOf(">", key_s ) + 1;
			else 
				break;
	        key_e = line.indexOf("<", key_s);
	        output += delimiter+line.substring(key_s, key_e).trim();
	
	        value_s=line.indexOf("<Value>", key_e);
			if (value_s!=-1)
				value_s = line.indexOf(">", value_s ) + 1;
			else
				break;
	        value_e = line.indexOf("<", value_s);
	        output += delimiter+line.substring(value_s, value_e).trim();	        
		}		
		
		return output;
	}
	

	public void actionPerformed(ActionEvent e) {

		String actionCommand = e.getActionCommand();

		if (e.getSource() instanceof JTextField) {
			
			try {
				
				String filename_list = jtf.getText().trim();
				filename_list="../"+filename_list;
				File input_file= new File(filename_list);
                if (!input_file.exists())
                	jta.append("File Do Not Exists! Please Re-enter the File List Name!\n");
                else{
                	Scanner file_lists = new Scanner(input_file);
                	while (file_lists.hasNext()) {
                		String file_name="../"+file_lists.nextLine().trim();
                		jta.append(file_name+ "\n");
                		String  output=xmlParser(file_name);
                		PrintStream printOut= new PrintStream(outputToServer);
            			printOut.println(output);	
                		
                	}
                }
			} catch (IOException ex){
				System.err.println(ex);
			}
		}
	}
}
