/********************************************************
 * 
 *        CS2310 Project -- Spring, 2003
 *    "Adaptive Intersection Traffic Lights System"
 *  Implementated with Timed Petri Net as the Backbone
 * 
 *      Designed by Yuqiang Huang
 *      Guided by Prof. S.K.Chang
 *      Computer Science Department
 *      University of Pittsburgh
 *      Pittsburgh,PA 15260
 * 
 *   Notice: As this Java Applet uses the advanced
 *           system level class - javax.swing.Timer,
 *           some advanced methods are only available
 *           Java 1.4.0 or later version. JRE 1.4.0
 *           is needed in order to enjoy this program.
 * 
 ******************************************************/

import java.awt.Panel;
import java.awt.Button;
import java.awt.Label;
import java.awt.Color;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Scrollbar;

public class TrafficLights extends java.applet.Applet{

	Panel pnw;
	Panel pn;
	Panel pne;
	Panel pw;
	Panel pc;
	Panel pe;
	Panel psw;
	Panel ps;
	Panel pse;

	LightController c;

	public void init(){
		
		setSize(450,450);
		setLayout(new BorderLayout());
		c = new LightController();
		
		createStreets();
		createLights();
		createTimerLable();
		createControls();
	}

	public void createStreets(){

		Panel p = new Panel();
		p.setLayout(new GridLayout(3,3));
		p.setBackground(Color.gray.brighter());

		p.add(pnw = new Panel());
		p.add(pn = new Panel());
		p.add(pne = new Panel());
		
		p.add(pw = new Panel());
		p.add(pc = new Panel());
		p.add(pe = new Panel());
		
		p.add(psw = new Panel());
		p.add(ps = new Panel());
		p.add(pse = new Panel());
			    
		pnw.setBackground(Color.green.darker());
		pne.setBackground(Color.green.darker());
		psw.setBackground(Color.green.darker());
		pse.setBackground(Color.green.darker());

		add("Center", p);
	}
	
	public void putButton(Panel p, Button b, String layout, int pos, String l) {
		
		p.setLayout(new GridLayout(3,3));
		b.setBackground(Color.black.brighter());
		
		int i;
		int labelPos = 5;
		
		if (pos<labelPos) {
		
			for (i=1; i<pos; i++)
				p.add(new Panel());
		
			Panel buttonP = new Panel();
			buttonP.setLayout(new BorderLayout());
			buttonP.add(b, layout);
			p.add(buttonP);
			
			for (i=pos+1; i<labelPos; i++)
				p.add(new Panel());
			
			Label directionLabel = new Label(l, Label.CENTER);
			Panel labelP = new Panel();
			labelP.setLayout(new BorderLayout());
			labelP.add(directionLabel, BorderLayout.CENTER);
			p.add(labelP);
			
			for (i=labelPos+1; i<=9; i++)
				p.add(new Panel());
		}
		else {
			
			for (i=1; i<labelPos; i++)
				p.add(new Panel());
			
			Label directionLabel = new Label(l, Label.CENTER);
			Panel labelP = new Panel();
			labelP.setLayout(new BorderLayout());
			labelP.add(directionLabel, BorderLayout.CENTER);
			p.add(labelP);
		
			for (i=labelPos+1; i<pos; i++)
				p.add(new Panel());
			
			Panel buttonP = new Panel();
			buttonP.setLayout(new BorderLayout());
			buttonP.add(b, layout);
			p.add(buttonP);			
			
			for (i=pos+1; i<=9; i++)
				p.add(new Panel());
		}
			
	}
	
	public void createTimerLable(){		
		
		pc.setLayout(new GridLayout(4,1));
		
		int i;
		
		pc.add(new Panel());			
			
		Label timerTitleLabel = new Label();
		timerTitleLabel.setAlignment(Label.CENTER);
		Panel timerTitleP = new Panel();
		timerTitleP.setLayout(new BorderLayout());
		timerTitleP.add(timerTitleLabel, BorderLayout.CENTER);
		pc.add(timerTitleP);
		
		Label timerValueLabel = new Label();
		timerValueLabel.setAlignment(Label.CENTER);
		Panel timerValueP = new Panel();
		timerValueP.setLayout(new BorderLayout());
		timerValueP.add(timerValueLabel, BorderLayout.CENTER);
		pc.add(timerValueP);
		
		c.setTimerLabel(timerTitleLabel, timerValueLabel);
		
		pc.add(new Panel());
	}

	public void createLights(){
		
		Button bn;
		Button bs;
		Button be;
		Button bw;
		
		bn = new Button();
		putButton(pn, bn, BorderLayout.SOUTH, 8, "N");
		c.addNorth(bn);

		bs = new Button();
		putButton(ps, bs, BorderLayout.NORTH, 2, "S");
		c.addSouth(bs);

		be = new Button();
		putButton(pe, be, BorderLayout.WEST, 4, "E");
		c.addEast(be);

		bw = new Button();
		putButton(pw, bw, BorderLayout.EAST, 6, "W");
		c.addEast(bw);
	}

	public void createControls(){
		
		Panel controlPanel=new Panel();
		controlPanel.setLayout(new GridLayout(1,3));
		
		Button b;

		b = new Button("Manual");
		b.addActionListener(c);
		b.setActionCommand("manual");
		controlPanel.add(b);

		b = new Button("Auto");
		b.addActionListener(c);
		b.setActionCommand("auto");
		controlPanel.add(b);

		b = new Button("Stop");
		b.addActionListener(c);
		b.setActionCommand("stop");
		controlPanel.add(b);
		

		/*
		Panel corner = new Panel();
		corner.setLayout(new GridLayout(2,2));
		
		b= new Button("nw");
		b.addActionListener(c);
		corner.add(b);
		
		b= new Button("ne");
		b.addActionListener(c);
		corner.add(b);
		
		b= new Button("sw");
		b.addActionListener(c);
		corner.add(b);
		
		b= new Button("se");
		b.addActionListener(c);
		corner.add(b);		
		controlPanel.add(corner);
		*/
		
		add("North",controlPanel);
		
		Panel sensorPanel=new Panel();
		sensorPanel.setLayout(new GridLayout(1,5));
		
		b = new Button("AllRed");
		b.addActionListener(c);
		b.setActionCommand("allflashred");
		sensorPanel.add(b);
		
		Label alignLabel = new Label("");
		sensorPanel.add(alignLabel);
		
		Label titleLabel = new Label("NS/EW TR:");
		sensorPanel.add(titleLabel);
		
		Label textLabel = new Label();
		textLabel.setAlignment(Label.CENTER);
		c.setRatioLabel(textLabel);
		sensorPanel.add(textLabel);

		Scrollbar controlValue = new Scrollbar(Scrollbar.HORIZONTAL, 50, 2, 0, 102);
		controlValue.addAdjustmentListener(c);
		sensorPanel.add(controlValue);
		
		add("South",sensorPanel);
	}
}
