/****************************************************
 * 
 *        CS2310 Project -- Spring, 2003
 *    "Adaptive Intersection Traffic Lights System"
 *  Implementated with Timed Petri Net as the Backbone * 
 * 
 *      Designed by Yuqiang Huang
 *      Guided by Prof. S.K.Chang
 *      Computer Science Department
 *      University of Pittsburgh
 *      Pittsburgh,PA 15260
 * 
 *   Notice: As this Java Applet uses the advanced
 *           system level class - javax.swing.Timer,
 *           some advanced methods are only available
 *           Java 1.4.0 or later version. JRE 1.4.0
 *           is needed in order to enjoy this program.
 * 
 ****************************************************/


import java.awt.Panel;
import java.awt.Button;
import java.awt.Label;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Vector;
import java.util.Enumeration;
import javax.swing.Timer;

public class LightController implements ActionListener, AdjustmentListener{
	
	private Label nsTrafficFlowPercent_Value;
	private Label timer_Title;
	private Label timer_Value;
	
	private Vector north = new Vector();
	private Vector south = new Vector();
	private Vector east  = new Vector();
	private Vector west  = new Vector();
	  
	private int  nsTrafficFlowPercent = 50;

	private String  flashType;
	
	private boolean iterTerminate = false;

	private boolean   flashRed      = false;
	private final int flashRedDelay = 1000;
	
	private final int JUST = 1000;
	
	private final long violationRedDelay = JUST*1;
	private final long yellowDelay       = JUST*2;
	private final long nsRedDelay_2      = yellowDelay;
	private final long ewRedDelay_2      = yellowDelay;
	
	private long nsRedDelay_1;
	private long nsGreenDelay;
	
	private long ewRedDelay_1;
	private long ewGreenDelay;
	
	private int cycle = 0;
	private Color[] colorsNS={Color.red,Color.red,Color.red,Color.green,Color.yellow,Color.red};
	private Color[] colorsEW={Color.green,Color.yellow,Color.red,Color.red,Color.red,Color.red};

	private javax.swing.Timer timer = new Timer(0,
		
		new ActionListener(){
			public void actionPerformed(ActionEvent e){
				
				//System.out.println("flashType: " + flashType);
				
				if (iterTerminate) {
					
					if (flashType.equals("allFlashRed")){
						
						timer_Title.setText("NS-EW have");
						timer_Value.setText("stop lights");
						allFlashRed();
					}
					else if (flashType.equals("nsFlashRed")){
						
						timer_Title.setText("NS has");
						timer_Value.setText("stop lights");
						nsFlashRed();
					}
					else if (flashType.equals("ewFlashRed")){
						
						timer_Title.setText("EW has");
						timer_Value.setText("stop lights");
						ewFlashRed();
					}
					else if (flashType.equals("autoCycle")){
						
						iterTerminate = false;
						startAuto();
					}
				}
				else {					
					autoCycle();
				}
			}
		}
	);
	
	
	public void setRatioLabel(Label l){	
		nsTrafficFlowPercent_Value = l;
		nsTrafficFlowPercent_Value.setText(nsTrafficFlowPercent + ":" +
										   (100-nsTrafficFlowPercent) );
	}
	
	public void setTimerLabel(Label tLabel, Label vLabel){
		timer_Title = tLabel;
		timer_Value = vLabel;
	}
	
	public void addNorth(Component c){
		north.addElement(c);
	}

	public void addSouth(Component c){
		south.addElement(c);
	}

	public void addEast(Component c){
		east.addElement(c);
	}

	public void addWest(Component c){
		west.addElement(c);
	}

	private void turn(Vector v, Color c){
		Enumeration e = v.elements();
		while (e.hasMoreElements()){
			((Component)e.nextElement()).setBackground(c);
		}
	}

	private void turnAll(Color c){
		turn(north,c);
		turn(south,c);
		turn(east,c);
		turn(west,c);
	}
	
	private void manualCycle(){
		
		turn(north,colorsNS[cycle]);
		turn(south,colorsNS[cycle]);
		turn(east,colorsEW[cycle]);
		turn(west,colorsEW[cycle]);
		if ((++cycle)==6){
			cycle = 0;
		}
	}
	
	private long startTime;
	private long endTime;
	private long delay;

	private void autoCycle(){
		
		if (arriveTimerDelay()) {
			
			timer.stop();
		
			if (cycle==0 && !flashType.equals("autoCycle")) {
				
					iterTerminate = true;	// terminate auto run
					timer.setDelay(flashRedDelay);
					timer.start();
			}
			else {
				
				if (cycle==0){
					iterTerminate = false;
					setDelays();
				}
				
				//System.out.println("cycle: " + cycle);
			
				turn(north,colorsNS[cycle]);
				turn(south,colorsNS[cycle]);
				turn(east,colorsEW[cycle]);
				turn(west,colorsEW[cycle]);
				
				printTimer();				
				
				/*
				if (cycle==0) {	//start of ew lights are green
					timer_Title.setText("EW Green Lights" + " " + cycle);
					timer_Value.setText(delay + " Milliseconds");
				}
				else if (cycle==1) {	//start of ew lights are yellow
					timer_Title.setText("EW Yellow Lights" + " " + cycle);
					timer_Value.setText(delay + " Milliseconds");
				}
				else if (cycle==2) {	//start of ew lights are vioRed
					timer_Title.setText("EW VioRed Lights" + " " + cycle);
					timer_Value.setText(delay + " Milliseconds");
				}
				else if (cycle==3) {	//start of ns lights are green
					timer_Title.setText("NS Green Lights" + " " + cycle);
					timer_Value.setText(delay + " Milliseconds");
				}
				else if (cycle==4) {	//start of ns lights are yellow
					timer_Title.setText("NS Yellow Lights" + " " + cycle);
					timer_Value.setText(delay + " Milliseconds");
				}
				else if (cycle==5) {	//start of ns lights are vioRed
					timer_Title.setText("NS VioRed Lights" + " " + cycle);
					timer_Value.setText(delay + " Milliseconds");
				}
				*/
			
				startTime = System.currentTimeMillis();
				timer.start();
			}
		}
	}
	
	
	private boolean arriveTimerDelay() {
		
		boolean arrive = true;
		
		endTime = System.currentTimeMillis();
		delay   = endTime - startTime;
		
		//System.out.println("delay: " + delay);	
		
		//timer_Title.setText("" + startTime + ";" + endTime);
		//timer_Value.setText("" + delay);
		//timer.stop();
		
		if ( isInRange(delay, nsRedDelay_1) && cycle==0)
			cycle = 1;
		else if ( isInRange(delay, nsRedDelay_2) && cycle==1)
			cycle = 2;
		else if ( isInRange(delay, violationRedDelay) && cycle == 2)
			cycle = 3;
		else if ( isInRange(delay, nsGreenDelay) && cycle==3)
			cycle = 4;
		else if ( isInRange(delay, yellowDelay) && cycle==4)
			cycle = 5;
		else if ( isInRange(delay, violationRedDelay) && cycle == 5)
			cycle = 0;
		else 
			arrive = false;
		
		//if (arrive)
			//System.out.println("next arrive: " + cycle);
		
		return arrive;
	}
	
	public boolean isInRange(long t1, long t2) {
		
		long range = 30;
		
		if (t2-range<t1 && t1<t2+range)
			return true;
		else
			return false;
	}
	
	private void nsFlashRed(){
		
		if (!flashRed){
			turn(north, Color.red);
			turn(south, Color.red);
			turn(east, Color.yellow);
			turn(west, Color.yellow);
			flashRed=true;
		} else {
			turnAll(Color.black);
			flashRed=false;
		}
	}
	
	private void ewFlashRed(){
		
		if (!flashRed){
			turn(north, Color.yellow);
			turn(south, Color.yellow);
			turn(east, Color.red);
			turn(west, Color.red);
			flashRed=true;
		} else {
			turnAll(Color.black);
			flashRed=false;
		}
	}
	
	private void allFlashRed(){
		
		if (!flashRed){
			turn(north, Color.red);
			turn(south, Color.red);
			turn(east, Color.red);
			turn(west, Color.red);
			flashRed=true;
		} else {
			turnAll(Color.black);
			flashRed=false;
		}
	}
	
	public void actionPerformed(ActionEvent e){
		
		if (e.getActionCommand().equals("manual")){
			//System.out.println("Action is manual"); //Debugging
			timer_Title.setText("manual");
			timer_Value.setText(null);
			timer.stop();
			manualCycle();
		}
		else if (e.getActionCommand().equals("auto")){
			//System.out.println("Action is auto"); //Debugging			
			if (!timer.isRunning()) {
				
				setFlashType();				
				if (flashType.equals("nsFlashRed")) {
					iterTerminate = true;
					timer.setDelay(flashRedDelay);
				}
				else if (flashType.equals("ewFlashRed")) {
					iterTerminate = true;
					timer.setDelay(flashRedDelay);
				}
				else if (flashType.equals("autoCycle")) {
					iterTerminate = false;
					timer.setDelay(0);
				}
				
				setDelays();
				
				turn(north,colorsNS[cycle]);
				turn(south,colorsNS[cycle]);
				turn(east,colorsEW[cycle]);
				turn(west,colorsEW[cycle]);
				
				printTimer();
				
				startTime = e.getWhen();
				timer.start();
			}
		}
		else if (e.getActionCommand().equals("stop")){
			//System.out.println("Action is stop"); //Debugging
			timer.stop();
			cycle = 0;
			timer_Title.setText("stop");
			timer_Value.setText(null);
			turnAll(Color.black);
		}
		else if (e.getActionCommand().equals("allflashred")){
			//System.out.println("Action is flashred"); //Debugging
			flashType="allFlashRed";
			if (!timer.isRunning()) {
				iterTerminate=true;
				timer.setDelay(flashRedDelay);
				timer.start();
			}
		}
	}
	
	public void startAuto() {
		
		timer.stop();
		timer.setDelay(0);
		
		cycle = 0;
		setDelays();
				
		turn(north,colorsNS[cycle]);
		turn(south,colorsNS[cycle]);
		turn(east,colorsEW[cycle]);
		turn(west,colorsEW[cycle]);
				
		printTimer();
				
		startTime = System.currentTimeMillis();
		timer.start();
	}
	
	public void printTimer() {
		
		//System.out.println("cycle: " + cycle);
		
		if (cycle==0) {	//start of ew lights are green
			timer_Title.setText("EW Green Lights");
			timer_Value.setText(ewGreenDelay + " Milliseconds");
		}
		else if (cycle==1) {	//start of ew lights are yellow
			timer_Title.setText("EW Yellow Lights");
			timer_Value.setText(yellowDelay + " Milliseconds");
		}
		else if (cycle==2) {	//start of ew lights are vioRed
			timer_Title.setText("EW VioRed Lights");
			timer_Value.setText(violationRedDelay + " Milliseconds");
		}
		else if (cycle==3) {	//start of ns lights are green
			timer_Title.setText("NS Green Lights");
			timer_Value.setText(nsGreenDelay + " Milliseconds");
		}
		else if (cycle==4) {	//start of ns lights are yellow
			timer_Title.setText("NS Yellow Lights");
			timer_Value.setText(yellowDelay + " Milliseconds");
		}
		else if (cycle==5) {	//start of ns lights are vioRed
			timer_Title.setText("NS VioRed Lights");
			timer_Value.setText(violationRedDelay + " Milliseconds");
		}
	}	
	
	private boolean nsFlashRed;
	private boolean nsFlashYellow;
	private boolean ewFlashRed;
	private boolean ewFlashYellow;
	
	public void adjustmentValueChanged(AdjustmentEvent e){
		
		nsTrafficFlowPercent = e.getValue();		
		//System.out.println("nsTrafficFlowPercent: " +
		//				   nsTrafficFlowPercent + "%"); //Debugging
		
		nsTrafficFlowPercent_Value.setText(nsTrafficFlowPercent + ":" +
										   (100-nsTrafficFlowPercent) );		
		setFlashType();
	}
	
	public void setFlashType() {
	
		if (nsTrafficFlowPercent<20) {
			flashType = "nsFlashRed";
		}
		else if (nsTrafficFlowPercent>80) {
			flashType = "ewFlashRed";
		}
		else {
			flashType = "autoCycle";
		}
	}
	
	public void setDelays() {
		
		nsGreenDelay = JUST*10*nsTrafficFlowPercent/100;
		ewGreenDelay = JUST*10*(100-nsTrafficFlowPercent)/100;
		
		nsRedDelay_1 = ewGreenDelay;
		ewRedDelay_1 = nsGreenDelay;
		
		//iterationDelay = nsRedDelay_1 + nsRedDelay_2 + violationRedDelay +
		//					nsGreenDelay + yellowDelay + violationRedDelay;
		//timer.setDelay(iterationDelay);
	}
}
