import processing.core.*;
import ddf.minim.*;
import ddf.minim.effects.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

/*
 * more info at : http://code.compartmental.net/tools/minim/quickstart/
 */
public class MySketch extends PApplet {


	Minim minim;
	AudioPlayer song;
	String filename;
	Boolean isStopped = false;
	Boolean isPaused = false;
	public void setup()
	{
	  size(512, 200);
	  minim = new Minim(this);
	  setSong("short.wav");
	}

	public void draw()
	{
	  background(0);
	 
	  stroke(255);
	  // we draw the waveform by connecting neighbor values with a line
	  // we multiply each of the values by 50 
	  // because the values in the buffers are normalized
	  // this means that they have values between -1 and 1. 
	  // If we don't scale them up our waveform 
	  // will look more or less like a straight line.
	  for(int i = 0; i < song.bufferSize() - 1; i++)
	  {
	    line(i, 50 + song.left.get(i)*50, i+1, 50 + song.left.get(i+1)*50);
	    line(i, 150 + song.right.get(i)*50, i+1, 150 + song.right.get(i+1)*50);
	  }
	}
	
	public void setSong(String filename){
		this.filename = filename;
		song = minim.loadFile(filename,2048);
		song.loop();
		isStopped = false;
	}
	public void play(){
		if(!isStopped)
			song.play();
		else
			setSong(filename);
		isPaused = false;
	}


	public void pause()
	{
		if(!isStopped && !isPaused ){
	  		song.pause();
			isPaused = true;
		}
		else
			System.out.println("cant pause. stopped");
	}


	public void stop()
	{
		if(!isStopped){
		  // always close Minim audio classes when you are done with them
		   isStopped = true;
			song.close();
		  // always stop Minim before exiting.
		  minim.stop();
		}
	}

public static void main(String args[]) {
	final MyFrame frame = new MyFrame();
	frame.show();
	
	// myApp.setVisible(true);
	//PApplet.main(new String[] { "--present", "MySketch" });
	final SoundPlayer player = new SoundPlayer();
	player.setVisible(true);
	player.pauseButton.addActionListener(new java.awt.event.ActionListener() {
	        public void actionPerformed(java.awt.event.ActionEvent evt) {
			System.out.println("PAUSE");
	            frame.sketch.pause();
	        }
	    });
	player.playButton.addActionListener(new java.awt.event.ActionListener() {
	        public void actionPerformed(java.awt.event.ActionEvent evt) {
			System.out.println("PLAY");
	            frame.sketch.play();
	        }
	    });
	player.stopButton.addActionListener(new java.awt.event.ActionListener() {
	        public void actionPerformed(java.awt.event.ActionEvent evt) {
			System.out.println("STOP");
	            frame.sketch.stop();
	        }
	    });
    player.loadButton.addActionListener(new java.awt.event.ActionListener() {
           public void actionPerformed(java.awt.event.ActionEvent evt) {
	
	        String oldText = player.songPathField.getText();

	        //file browser
	        JFileChooser fc = new JFileChooser();
	        FileNameExtensionFilter filter = new FileNameExtensionFilter("WAVE audio file", "wav", "wave", "WAV", "WAVE");
	        fc.addChoosableFileFilter(filter);
	        fc.showOpenDialog(player);

	        //if (returnVal == JFileChooser.APPROVE_OPTION) {
	            player.songFile = fc.getSelectedFile();
	            player.songPathField.setText(player.songFile.toString());
				frame.sketch.stop();
				frame.sketch.setSong(player.songFile.toString());
	        //}
	
           }
       });
  }

}