
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.event.ChangeEvent;
import java.util.Hashtable;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SoundPlayer.java
 *
 * Created on Mar 17, 2011, 6:30:01 PM
 */
/**
 *
 * @author Taylor
 */
public class SoundPlayer extends javax.swing.JFrame {

    private int returnVal;
    public File songFile = null;
    /** Creates new form SoundPlayer */
    private boolean isPlaying = false;

    public SoundPlayer() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
	
		//Create the slider
		JSlider framesPerSecond = new JSlider(JSlider.VERTICAL,0, 100, 50);
		framesPerSecond.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				System.out.println("stat changed");
			}
		});
		framesPerSecond.setMajorTickSpacing(10);
		framesPerSecond.setPaintTicks(true);

		//Create the label table
		Hashtable labelTable = new Hashtable();
		labelTable.put( new Integer( 0 ), new JLabel("Stop") );
		labelTable.put( new Integer( 50 ), new JLabel("Slow") );
		labelTable.put( new Integer( 100 ), new JLabel("Fast") );
		framesPerSecond.setLabelTable( labelTable );

		framesPerSecond.setPaintLabels(true);
	

        loadButton = new javax.swing.JButton();
        songPathField = new javax.swing.JTextField();
        playButton = new javax.swing.JButton();
        pauseButton = new javax.swing.JButton();
        stopButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        loadButton.setText("Load");
        // loadButton.addActionListener(new java.awt.event.ActionListener() {
        //     public void actionPerformed(java.awt.event.ActionEvent evt) {
        //         loadButtonActionPerformed(evt);
        //     }
        // });

        songPathField.setText("Select song...");

        playButton.setText("Play");
        // playButton.addActionListener(new java.awt.event.ActionListener() {
        //     public void actionPerformed(java.awt.event.ActionEvent evt) {
        //         playButtonActionPerformed(evt);
        //     }
        // });

        pauseButton.setText("Pause");
        // pauseButton.addActionListener(new java.awt.event.ActionListener() {
        //     public void actionPerformed(java.awt.event.ActionEvent evt) {
        //         pauseButtonActionPerformed(evt);
        //     }
        // });

        stopButton.setText("Stop");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());

        getContentPane().setLayout(layout);

        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGap(30, 30, 30)
                        .addComponent(playButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(65, 65, 65)
                        .addComponent(pauseButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(87, 87, 87)
                        .addComponent(stopButton))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(59, 59, 59)
                        .addComponent(songPathField, javax.swing.GroupLayout.DEFAULT_SIZE, 231, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(loadButton)))
                .addGap(49, 49, 49))
        );

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(171, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(playButton)
                    .addComponent(stopButton)
                    .addComponent(pauseButton))
                .addGap(53, 53, 53)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadButton)
                    .addComponent(songPathField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(30, 30, 30))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void playButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playButtonActionPerformed
        // TODO add your handling code here:
        if (songFile != null && !isPlaying) {
            //AePlayWave(songPathField.getText()).start();
            //wavPlayer.auline.start();
            

            //wavPlayer.setSong(songFile.toString());

            isPlaying = true;
            //wavPlayer.state = wavPlayer.state.PLAY;
            //wavPlayer.start();
            playButton.setEnabled(false);
        }

    }//GEN-LAST:event_playButtonActionPerformed

    private void loadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadButtonActionPerformed
        String oldText = songPathField.getText();

        //file browser
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("WAVE audio file", "wav", "wave", "WAV", "WAVE");
        fc.addChoosableFileFilter(filter);
        fc.showOpenDialog(SoundPlayer.this);

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            songFile = fc.getSelectedFile();
            songPathField.setText(songFile.toString());
        }
    }//GEN-LAST:event_loadButtonActionPerformed

    private void pauseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pauseButtonActionPerformed
        // TODO add your handling code here:
        if (isPlaying) {
            System.out.println("Pausing");
            pauseButton.setText("Resume");            
            isPlaying = false;
        }
        else
        {
            System.out.println("Resuming");
            pauseButton.setText("Pause");
            isPlaying = true;
        }
    }//GEN-LAST:event_pauseButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JButton loadButton;
    public javax.swing.JButton pauseButton;
    public javax.swing.JButton playButton;
    public javax.swing.JTextField songPathField;
    public javax.swing.JButton stopButton;
    // End of variables declaration//GEN-END:variables
}
