import java.lang.*;

class HandTracker implements Runnable
{
    private boolean _go = true;

    public static void main(String[] args)
    {
        //new Thread(new HandTracker()).start();
        new HandTracker().run();
    }

    public HandTracker()
    {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        RegisterGestureCallbackObject(new GestureCallbackObj());
        RegisterHandCallbackObject(new HandCallbackObj());
    }

    public synchronized boolean i_should_go()
    {
        return _go;
    }

    public synchronized void set_go(boolean run)
    {
        _go = run;
    }

    public void run()
    {
        init();
        while(i_should_go()) { waitOnce(); }
        shutDown();
    }

    public native void init();

    public native void shutDown();

    public native void waitOnce();

    public native void RegisterHandCallbackObject(IHandCallbackObject obj);
    public native void UnRegisterHandCallbackObject();

    public native void RegisterGestureCallbackObject(IGestureCallbackObject obj);
    public native void UnRegisterGestureCallbackObject();

    class GestureCallbackObj extends IGestureCallbackObject
    {
        public void GestureRecognized(String gesture, Point3D idPos)
        {
            System.out.printf("[HandTracker - java] recognized gesture \"%s\" @ <%f, %f, %f>\n", gesture, idPos.X, idPos.Y, idPos.Z);
        }
    }

    class HandCallbackObj extends IHandCallbackObject
    {
        public void HandUpdate(int user, Point3D pos, float fTime)
        {
            System.out.printf("hand update user %d: [%f] <%f, %f, %f>\n", user, fTime, pos.X, pos.Y, pos.Z);
        }
    }

    static
    {
        System.loadLibrary("HandTracker");
    }

    class ShutdownHook extends Thread
    {
        public void run()
        {
            set_go(false);
            System.out.println("goodbye\n");
        }
    }
}

