#ifndef __GESTURE_RECOGNIZER_H__
#define __GESTURE_RECOGNIZER_H__

class HandsGenerator;
class GestureGenerator;
class UserGenerator;
class SkeletonCapability;
class PoseDetectionCapability;

#include <string>

class GestureRecognizer
{
public:
    GestureRecognizer();
    ~GestureRecognizer();

    // Hands
    typedef void (XN_CALLBACK_TYPE* HandCreate)(xn::HandsGenerator& generator, XnUserID user, const XnPoint3D* pPosition, XnFloat fTime, void* pCookie);
    typedef void (XN_CALLBACK_TYPE* HandUpdate)(xn::HandsGenerator& generator, XnUserID user, const XnPoint3D* pPosition, XnFloat fTime, void* pCookie);
    typedef void (XN_CALLBACK_TYPE* HandDestroy)(xn::HandsGenerator& generator, XnUserID user, XnFloat fTime, void* pCookie); 
    // User
    typedef void (XN_CALLBACK_TYPE* UserHandler)(xn::UserGenerator& generator, XnUserID user, void* pCookie);
    // Gesture
    typedef void (XN_CALLBACK_TYPE* GestureRecognized)(xn::GestureGenerator& generator, const XnChar* strGesture, const XnPoint3D* pIDPosition, const XnPoint3D* pEndPosition, void* pCookie);
    typedef void (XN_CALLBACK_TYPE* GestureProgress)(xn::GestureGenerator& generator, const XnChar* strGesture, const XnPoint3D* pPosition, XnFloat fProgress, void* pCookie);

    typedef void(*  CalibrationStart )(xn::SkeletonCapability &skeleton, XnUserID user, void *pCookie);
    typedef void(*  CalibrationEnd )(xn::SkeletonCapability &skeleton, XnUserID user, XnBool bSuccess, void *pCookie);

    
    // initialization / control
    int init(const std::string& str = std::string());
    void shutdown();
    XnStatus startGeneratingAll();
    XnStatus stopGeneratingAll();
    XnStatus waitAndUpdateAll();

    // gesture callback registration
    XnStatus registerGestureCallbacks(
        GestureRecognized,
        GestureProgress,
        void *pCookie = 0 /* user's cookie, delivered to callbacks */
    );

    XnStatus unregisterGestureCallbacks(void);
    
    // gesture interface
    XnStatus addGesture(const XnChar *name, XnBoundingBox3D *pArea = 0);
    XnStatus removeGesture(const XnChar *name);

    // user callback registration
    XnStatus registerUserCallbacks(
        UserHandler newUserCB,
        UserHandler lostUserCB,
        void *pCookie = 0
    );

    XnStatus unregisterUserCallbacks(void);

    XnStatus registerCalibrationCallbacks(
        CalibrationStart,
        CalibrationEnd,
        void *pCookie = 0
    );

    void unregisterCalibrationCallbacks(void);

    XnStatus setSkeletonProfile(XnSkeletonProfile);

    // "user" interface
    xn::SkeletonCapability getSkeletonCapability();
    xn::PoseDetectionCapability getPoseDetectionCapability();
    XnUInt16 getNumberOfUsers() const;
    XnStatus getUsers(XnUserID users[], XnUInt16 &nUsers) const;
    XnBool needPose() const;
    const std::string& getPoseName() const;

    // hand callback registration
    XnStatus registerHandCallbacks(
        HandCreate,
        HandUpdate,
        HandDestroy,
        void *pCookie = 0
    );

    XnStatus unregisterHandCallbacks(void);

    // hand interface
    XnStatus stopTrackingHandsUser(XnUserID user);
    XnStatus stopTrackingHandsAll();
    XnStatus startTrackingHands(const XnPoint3D &position);

    /** the metal.. **/

    inline xn::Context& context() {return g_Context;}
    inline const xn::Context& context() const {return g_Context;}
    inline xn::DepthGenerator& depthGenerator() {return g_DepthGenerator;}
    inline const xn::DepthGenerator& depthGenerator() const {return g_DepthGenerator;}
    inline xn::UserGenerator& userGenerator() {return g_UserGenerator;}
    inline const xn::UserGenerator& userGenerator() const {return g_UserGenerator;}
    inline xn::HandsGenerator& handsGenerator() {return g_HandsGenerator;}
    inline const xn::HandsGenerator& handsGenerator() const {return g_HandsGenerator;}
    inline xn::GestureGenerator& gestureGenerator() {return g_GestureGenerator;}
    inline const xn::GestureGenerator& gestureGenerator() const {return g_GestureGenerator;}

private: 
    xn::Context g_Context;
    xn::DepthGenerator g_DepthGenerator;
    xn::UserGenerator g_UserGenerator;
    xn::HandsGenerator g_HandsGenerator;
    xn::GestureGenerator g_GestureGenerator;

    XnBool _needPose;
    std::string _poseName;
};

#endif
