#include <XnCppWrapper.h>
#include <XnOpenNI.h>
#include <XnCodecIDs.h>

#include "GestureRecognizer.h"

using namespace std;

XnCallbackHandle _hUserCallbacks,
                 _hCalibrationCallbacks,
                 _hPoseCallbacks,
                 _hHandsCallbacks,
                 _hGestureCallbacks,
                 _hSkeletonCallbacks;

//////////////////////////////////////////////////////////////////////////
/*
void User_NewUser(xn::UserGenerator& generator, XnUserID nId, void* pCookie);
void User_LostUser(xn::UserGenerator& generator, XnUserID nId, void* pCookie);
void UserPose_PoseDetected(xn::PoseDetectionCapability& capability, const XnChar* strPose, XnUserID nId, void* pCookie);
void UserCalibration_CalibrationStart(xn::SkeletonCapability& capability, XnUserID nId, void* pCookie);
void UserCalibration_CalibrationEnd(xn::SkeletonCapability& capability, XnUserID nId, XnBool bSuccess, void* pCookie);
void Hands_HandCreate(xn::HandsGenerator& generator, XnUserID nId, const XnPoint3D *pPosition, XnFloat fTime, void* pCookie);
void Hands_HandDestroy(xn::HandsGenerator& generator, XnUserID nId, XnFloat fTime, void* pCookie);
void newpoint(const XnPoint3D *point, const XnVector3D& vel, const XnVector3D& accel);
void Hands_HandUpdate(xn::HandsGenerator& generator, XnUserID nId, const XnPoint3D *pPosition, XnFloat fTime, void* pCookie);
void Gesture_Recognized(xn::GestureGenerator& generator, const XnChar* strGesture, const XnPoint3D* pIDPosition, const XnPoint3D* pEndPosition, void* pCookie);
void Gesture_Progress(xn::GestureGenerator& generator, const XnChar* strGesture, const XnPoint3D* pPosition, const XnFloat progress, void* pCookie);
*/
//////////////////////////////////////////////////////////////////////////


GestureRecognizer::GestureRecognizer():
    _needPose(false)
{
}

GestureRecognizer::~GestureRecognizer()
{
}

// From OpenNI demo
#define CHECK_RC(nRetVal, what)										\
	if (nRetVal != XN_STATUS_OK)									\
	{																\
		printf("%s failed: %s\n", what, xnGetStatusString(nRetVal));\
		return nRetVal;												\
	}

#define DEFAULT_XML_PATH "Config.xml"

int GestureRecognizer::init(const std::string &filename)
{
    XnStatus nRetVal = XN_STATUS_OK;
	if(filename.size() > 0)
	{
        /*
        if('r' == *argv[1])
        {
            nRetVal = g_Context.Init();
            CHECK_RC(nRetVal, "Init");
            nRetVal = g_Context.OpenFileRecording(argv[1]);
            if (nRetVal != XN_STATUS_OK)
            {
                printf("Can't open recording %s: %s\n", argv[1], xnGetStatusString(nRetVal));
                return 1;
            }
        }
        */

        nRetVal = g_Context.InitFromXmlFile(filename.c_str());
        CHECK_RC(nRetVal, "InitFromXml");
	}
    else
    {
        nRetVal = g_Context.InitFromXmlFile(DEFAULT_XML_PATH);
        CHECK_RC(nRetVal, "InitFromXml");
    }

	nRetVal = g_Context.FindExistingNode(XN_NODE_TYPE_DEPTH, g_DepthGenerator);
	CHECK_RC(nRetVal, "Find depth generator");
	nRetVal = g_Context.FindExistingNode(XN_NODE_TYPE_USER, g_UserGenerator);
	if (nRetVal != XN_STATUS_OK)
	{
		nRetVal = g_UserGenerator.Create(g_Context);
		CHECK_RC(nRetVal, "Find user generator");
	}

    nRetVal = g_Context.FindExistingNode(XN_NODE_TYPE_HANDS, g_HandsGenerator);
	if (nRetVal != XN_STATUS_OK)
	{
		nRetVal = g_HandsGenerator.Create(g_Context);
		CHECK_RC(nRetVal, "Find hand generator");
	}

    nRetVal = g_Context.FindExistingNode(XN_NODE_TYPE_GESTURE, g_GestureGenerator);
    if(nRetVal != XN_STATUS_OK)
    {
        nRetVal = g_GestureGenerator.Create(g_Context);
        CHECK_RC(nRetVal, "Find gesture generator");
    }

    // TODO: option
	if (!g_UserGenerator.IsCapabilitySupported(XN_CAPABILITY_SKELETON))
	{
		printf("Supplied user generator doesn't support skeleton\n");
		return 1;
	}

	if (g_UserGenerator.GetSkeletonCap().NeedPoseForCalibration())
	{
		_needPose = TRUE;
		if (!g_UserGenerator.IsCapabilitySupported(XN_CAPABILITY_POSE_DETECTION))
		{
			printf("Pose required, but not supported\n");
			return 1;
		}
		//g_UserGenerator.GetPoseDetectionCap().RegisterToPoseCallbacks(UserPose_PoseDetected, NULL, NULL, _hPoseCallbacks);
        XnChar pose[20] = "";
		g_UserGenerator.GetSkeletonCap().GetCalibrationPose(pose);
        _poseName = pose;
	}

	g_UserGenerator.GetSkeletonCap().SetSkeletonProfile(XN_SKEL_PROFILE_ALL);
    /*
    if(!g_HandsGenerator.IsCapabilitySupported(XN_CAPABILITY_USER_POSITION))
    {
        printf("Position required, but not supported\n");
        return 1;
    }
    */

    /*
    if(!g_GestureGenerator.IsGestureProgressSupported())
    {
        printf("Gesture progress required, but not supported\n");
        return 1;
    }
    */

    return XN_STATUS_OK;
}

void GestureRecognizer::shutdown()
{
	g_Context.Shutdown();
}

XnStatus GestureRecognizer::startGeneratingAll()
{
    return g_Context.StartGeneratingAll();
}

XnStatus GestureRecognizer::stopGeneratingAll()
{
    return g_Context.StopGeneratingAll();
}

XnStatus GestureRecognizer::waitAndUpdateAll()
{
    return g_Context.WaitAndUpdateAll();
}

XnStatus GestureRecognizer::registerGestureCallbacks(
    GestureRecognized recognized,
    GestureProgress progress,
    void *pCookie)
{
    return g_GestureGenerator.RegisterGestureCallbacks(
        recognized, progress, pCookie, _hGestureCallbacks);
}

XnStatus GestureRecognizer::unregisterGestureCallbacks()
{
    g_GestureGenerator.UnregisterGestureCallbacks(_hGestureCallbacks);
    return XN_STATUS_OK;
}

XnStatus GestureRecognizer::addGesture(const XnChar *name, XnBoundingBox3D *pArea)
{
    return g_GestureGenerator.AddGesture(name, pArea);
}

XnStatus GestureRecognizer::removeGesture(const XnChar *name)
{
    return g_GestureGenerator.RemoveGesture(name);
}

XnStatus GestureRecognizer::registerUserCallbacks(
    UserHandler newUserCB,
    UserHandler lostUserCB,
    void *pCookie)
{
    return g_UserGenerator.RegisterUserCallbacks(
        newUserCB, lostUserCB, pCookie, _hUserCallbacks);
}

XnStatus GestureRecognizer::unregisterUserCallbacks()
{
    g_UserGenerator.UnregisterUserCallbacks(_hUserCallbacks);
    return XN_STATUS_OK;
}

XnStatus GestureRecognizer::registerCalibrationCallbacks(
    CalibrationStart start,
    CalibrationEnd end,
    void *pCookie)
{
    return g_UserGenerator.GetSkeletonCap().RegisterCalibrationCallbacks(
        start, end, pCookie, _hSkeletonCallbacks);
}

void GestureRecognizer::unregisterCalibrationCallbacks(void)
{
    return g_UserGenerator.GetSkeletonCap().UnregisterCalibrationCallbacks(_hSkeletonCallbacks);
}

XnStatus GestureRecognizer::setSkeletonProfile(XnSkeletonProfile p)
{
    return g_UserGenerator.GetSkeletonCap().SetSkeletonProfile(p);
}

xn::SkeletonCapability GestureRecognizer::getSkeletonCapability()
{
    return g_UserGenerator.GetSkeletonCap();
}

xn::PoseDetectionCapability GestureRecognizer::getPoseDetectionCapability()
{
    return g_UserGenerator.GetPoseDetectionCap();
}

XnUInt16 GestureRecognizer::getNumberOfUsers() const
{
    return g_UserGenerator.GetNumberOfUsers();
}

XnStatus GestureRecognizer::getUsers(XnUserID users[], XnUInt16 &nUsers) const
{
    return g_UserGenerator.GetUsers(users, nUsers);
}

XnBool GestureRecognizer::needPose() const
{
    return _needPose;
}

const string& GestureRecognizer::getPoseName() const
{
    return _poseName;
}

// hand callback registration
XnStatus GestureRecognizer::registerHandCallbacks(
    HandCreate create,
    HandUpdate update,
    HandDestroy destroy,
    void *pCookie)
{
    return g_HandsGenerator.RegisterHandCallbacks(
        create, update, destroy, pCookie, _hHandsCallbacks);
}

XnStatus GestureRecognizer::unregisterHandCallbacks(void)
{
    g_HandsGenerator.UnregisterHandCallbacks(_hHandsCallbacks);
    return XN_STATUS_OK;
}

// hand interface
XnStatus GestureRecognizer::stopTrackingHandsUser(XnUserID user)
{
    return g_HandsGenerator.StopTracking(user);
}

XnStatus GestureRecognizer::stopTrackingHandsAll()
{
    return g_HandsGenerator.StopTrackingAll();
}

XnStatus GestureRecognizer::startTrackingHands(const XnPoint3D &position)
{
    return g_HandsGenerator.StartTracking(position);
}

